IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[P_RC_CREDIARIO_FECHA]') AND type in (N'P', N'PC'))
	DROP PROCEDURE [dbo].[P_RC_CREDIARIO_FECHA]
GO

--EXEC P_RC_CREDIARIO_FECHA 1, 1220566, '20100621', NULL, 0  
CREATE PROCEDURE [dbo].[P_RC_CREDIARIO_FECHA]( @CD_EMP    INT,  
												@CD_CLI     INT,                              
												@DT_FECHA   DATETIME,  
												@DT_VENCTO   DATETIME,  
												@TP_FECH            INT,  
												@CD_MDL_VD   NVARCHAR(500),
												@CD_GRP_ECON INT)    
  
AS  
BEGIN  
--EXEC P_RC_CREDIARIO_FECHA 1, 1220566, '20100621', NULL, 0  
--Desabilitando a qtde de registros afetados a cada instrucao para que a procedure retorne dados para o Visual Basic  
SET NOCOUNT ON  
       
CREATE TABLE #RS_MOV_CRED (  CD_CTR    INT,      
							CD_CLI    INT,  
							RZ_CLI       NVARCHAR(100),  
							DT_LANC_CRED        DATETIME,       --DATA DE LANcAMENTO DA PARCELA OU JUROS  
							DT_FECHA_CRED       DATETIME,  --DATA DE VENCIMENTO DA PARCELA OU JUROS  
							DT_FECHA        DATETIME,  --DATA DE FECHAMENTO DO CREDIARIO  
							DT_LIMITE_PGTO     DATETIME,  --DATA DE LIMITE DE PAGAMENTO DA FATURA  
							DT_VENCTO     DATETIME,  --DATA DE VENCIMENTO DO CREDIARIO  
							VLR_LANC     MONEY,  
							CD_CTR_FECHA  INT,  
							PERC_MIN_RECB_FAT   MONEY,  
							CD_TP_LANC   INT)  

CREATE TABLE #RS_MOV_CRED_AUX (  CD_CTR    INT,      
							CD_CLI    INT,  
							RZ_CLI       NVARCHAR(100),  
							DT_LANC_CRED        DATETIME,       --DATA DE LANcAMENTO DA PARCELA OU JUROS  
							DT_FECHA_CRED       DATETIME,  --DATA DE VENCIMENTO DA PARCELA OU JUROS  
							DT_FECHA        DATETIME,  --DATA DE FECHAMENTO DO CREDIARIO  
							DT_LIMITE_PGTO     DATETIME,  --DATA DE LIMITE DE PAGAMENTO DA FATURA  
							DT_VENCTO     DATETIME,  --DATA DE VENCIMENTO DO CREDIARIO  
							VLR_LANC     MONEY,  
							CD_CTR_FECHA  INT,  
							PERC_MIN_RECB_FAT   MONEY,  
							CD_TP_LANC   INT ,
							 PERC_JUROS_ATRASO money,
							 RC_CRED_VL_PGTO money,
							 RC_DEB_DT_VENCTO date)

  
CREATE TABLE #RS_CLI_CREDIARIO (      
    CD_EMP              INT,  
    CD_CLI              INT,    
    RZ_CLI              NVARCHAR(100),    
    DT_FECHA            DATETIME,  
    DT_LIMITE_PGTO      DATETIME,  
    DT_VENCTO           DATETIME,  
    CD_CTR_FECHA        INT,  
    PERC_MIN_RECB_FAT   MONEY,   
    PERC_JUROS_MULTA    MONEY,  
    PERC_JUROS_ATRASO   MONEY,  
    PERC_JUROS_REFIN    MONEY,   
    DIAS_CAREN_ATRASO   INT,    
    CD_MDL_VD           INT,  
    TP_VENCTO           INT,  
    DIA_VENCTO          INT,  
    DIA_FECHA           INT,  
    FLAG_REFIN_SLD      INT)  
          
CREATE TABLE  #RsMdlVd (   CD_EMP              INT,  
							CD_MDL_VD INT);





DECLARE @DT_MES_ANT DATETIME  
DECLARE @DT_MES_ATU DATETIME  
DECLARE @DT_MES_FUT DATETIME  
  
DECLARE @DT_BASE    DATETIME  
  
--SET @DT_MES_ANT = DATEADD(MONTH,-1,GETDATE())  
--SET @DT_MES_ATU = GETDATE()  
--SET @DT_MES_FUT = DATEADD(MONTH, 1,GETDATE())  
  
SET @DT_BASE = @DT_FECHA  
  
SET @DT_MES_ANT = DATEADD(MONTH,-1,@DT_FECHA)  
SET @DT_MES_ATU = @DT_FECHA  
SET @DT_MES_FUT = DATEADD(MONTH, 1,@DT_FECHA)  
    
	if @CD_MDL_VD <> ''
	begin
		insert into #RsMdlVd   
		select 
			CD_EMP,CD_MDL_VD
		FROM 
			RC_MDL_VENDA
		where	
			CD_MDL_VD IN (SELECT ID FROM UFD_PRM_IN_STRING(@CD_MDL_VD));
	end
	else
	begin
		select distinct
			CD_EMP,CD_MDL_VD
		FROM 
			RC_CLI_CREDIARIO
		where	
			cd_emp =@cd_emp

	end


-----------------------------------------------------------------------------------------------------------  
--Capturando os clientes para fechamento.  
--Se a data de fechamento do cliente for maior que a data informada, entao pega a movimentacao do mes anterior  
--Senao, pega a movimentacao do mes atual  
-----------------------------------------------------------------------------------------------------------  
IF @TP_FECH = 0   
--SE O @TP_FECH = 0, ENTAO A FUNCAO OBEDECER O DIA DE FECHAMENTO DO CLIENTE  
--SE O @TP_FECH = 1, ENTAO A FUNCAO TRATAR TODAS AS MOVIMENTACOES EM ABERTO, INCLUSIVE OS FECHAMENTOS NAO PAGOS  
--OBS.: QUANDO O @TP_FECH = 1, A DATA DE VENCIMENTO  OBRIGATORIA  
 BEGIN  
  
  print 'insert 1 #RS_CLI_CREDIARIO  ' + convert(varchar, getdate(),108);

  INSERT INTO #RS_CLI_CREDIARIO  
  SELECT  
   RC_CLI_CREDIARIO.CD_EMP,  
   RC_CLI_CREDIARIO.CD_CLI,  
   RC_CLI.RZ_CLI,  
   -------------------------------------------------------------  
   --Montando data de fechamento  
   -------------------------------------------------------------  
   DBO.F_RET_DATA_VALIDA  ((CASE WHEN RC_MDL_VENDA.TP_FECHA = 0 THEN --Dia do Mes  
           (CASE WHEN RC_MDL_VENDA.DIA_FECHA >= DAY(@DT_BASE) THEN  
            CAST(YEAR(@DT_MES_ANT) AS VARCHAR) + RIGHT('0' + CAST(MONTH(@DT_MES_ANT) AS VARCHAR),2) + RIGHT('0' +CAST(RC_MDL_VENDA.DIA_FECHA AS VARCHAR),2)    
            ELSE  
            CAST(YEAR(@DT_MES_ATU) AS VARCHAR) + RIGHT('0' + CAST(MONTH(@DT_MES_ATU) AS VARCHAR),2) + RIGHT('0' +CAST(RC_MDL_VENDA.DIA_FECHA AS VARCHAR),2)  
            END)   
  
           WHEN RC_MDL_VENDA.TP_FECHA = 1 THEN --Dia apos compra  
            CONVERT(CHAR(10), @DT_BASE, 112)  
  
           WHEN RC_MDL_VENDA.TP_FECHA = 2 THEN --Dia da semana  
           (CASE WHEN DATEPART(DW, @DT_BASE) > RC_MDL_VENDA.DIA_FECHA THEN  
            CONVERT(CHAR(10), DATEADD(DAY, -(DATEPART(DW, @DT_BASE) - RC_MDL_VENDA.DIA_FECHA) ,@DT_BASE), 112)  
            ELSE  
            CONVERT(CHAR(10), DATEADD(DAY, -(7 - RC_MDL_VENDA.DIA_FECHA + DATEPART(DW, @DT_BASE)) ,@DT_BASE), 112)  
            END)   
  
           WHEN RC_MDL_VENDA.TP_FECHA = 3 THEN --Quinzenal  
           (CASE WHEN DAY(@DT_BASE) <= 15 THEN  
            CONVERT(CHAR(10), DBO.F_FINAL_MES(@DT_MES_ANT), 112)  
            ELSE  
            CAST(YEAR(@DT_MES_ATU) AS VARCHAR) + RIGHT('0' + CAST(MONTH(@DT_MES_ATU) AS VARCHAR),2) + '15'  
            END)            
  
          END)) AS DT_FECHA,   
  
   -------------------------------------------------------------  
   --Montando data de limite para pagamento  
   -------------------------------------------------------------  
   DBO.F_RET_DATA_VALIDA  ((CASE WHEN RC_MDL_VENDA.TP_FECHA = 0 THEN --Dia do Mes  
           (CASE WHEN RC_MDL_VENDA.DIA_FECHA >= DAY(@DT_BASE) THEN  
            CAST(YEAR(@DT_MES_ATU) AS VARCHAR) + RIGHT('0' + CAST(MONTH(@DT_MES_ATU) AS VARCHAR),2) + RIGHT('0' +CAST(RC_MDL_VENDA.DIA_FECHA AS VARCHAR),2)    
            ELSE  
            CAST(YEAR(@DT_MES_FUT) AS VARCHAR) + RIGHT('0' + CAST(MONTH(@DT_MES_FUT) AS VARCHAR),2) + RIGHT('0' +CAST(RC_MDL_VENDA.DIA_FECHA AS VARCHAR),2)  
            END)   
  
          WHEN RC_MDL_VENDA.TP_FECHA = 1 THEN --Dias apos compra  
            NULL  
  
          WHEN RC_MDL_VENDA.TP_FECHA = 2 THEN --Dia da semana  
           (CASE WHEN DATEPART(DW, @DT_BASE) >= DIA_FECHA THEN  
            CONVERT(CHAR(10), DATEADD(DAY, (7 - DATEPART(DW, @DT_BASE)) + DIA_FECHA, @DT_BASE), 112)           
            ELSE  
            CONVERT(CHAR(10), DATEADD(DAY, DIA_FECHA - DATEPART(DW, @DT_BASE) , @DT_BASE), 112)  
            END)  
  
          WHEN RC_MDL_VENDA.TP_FECHA = 3 THEN --Quinzenal  
           (CASE WHEN DAY(@DT_BASE) <= 15 THEN  
            CONVERT(CHAR(10), DBO.F_FINAL_MES(@DT_BASE), 112)  
            ELSE  
            CONVERT(CHAR(10), DATEADD(DAY, 15, DBO.F_FINAL_MES(@DT_BASE)), 112)           
            END)  
  
          END)) AS DT_LIMITE_PGTO,  
    -------------------------------------------------------------  
  
    NULL AS DT_VENCTO,  
  
    (SELECT MAX(CD_CTR_FECHA) FROM RC_CREDIARIO_FECHA WHERE CD_EMP = RC_CLI_CREDIARIO.CD_EMP AND CD_CLI = RC_CLI_CREDIARIO.CD_CLI AND FLAG_NAO_FECHAR = 0) AS CD_CTR_FECHA,  
    (CASE WHEN ISNULL(RC_MDL_VENDA.PERC_MIN_RECB_FAT,0) <= 0 THEN 100 ELSE ISNULL(RC_MDL_VENDA.PERC_MIN_RECB_FAT,0) END) AS PERC_MIN_RECB_FAT,  
    RC_MDL_VENDA.PERC_JUROS_MULTA,  
    RC_MDL_VENDA.PERC_JUROS_ATRASO,  
    RC_MDL_VENDA.PERC_JUROS_REFIN,  
    RC_MDL_VENDA.DIAS_CAREN_ATRASO,  
    RC_CLI_CREDIARIO.CD_MDL_VD,  
    RC_MDL_VENDA.TP_VENCTO,  
    RC_MDL_VENDA.DIA_VENCTO,  
    RC_MDL_VENDA.DIA_FECHA,  
    ISNULL(RC_MDL_VENDA.FLAG_REFIN_SLD,0)  
  FROM   
	RC_CLI_CREDIARIO 
	INNER JOIN RC_MDL_VENDA ON  
	RC_CLI_CREDIARIO.CD_EMP   = RC_MDL_VENDA.CD_EMP  AND 
	RC_CLI_CREDIARIO.CD_MDL_VD = RC_MDL_VENDA.CD_MDL_VD  
	
	INNER JOIN RC_CLI ON  
	RC_CLI_CREDIARIO.CD_EMP   = RC_CLI.CD_EMP  AND 
	RC_CLI_CREDIARIO.CD_CLI   = RC_CLI.CD_CLI   
    INNER JOIN #RsMdlVd M ON 
	RC_MDL_VENDA.CD_EMP		= M.CD_EMP  AND 
	RC_MDL_VENDA.CD_MDL_VD  = M.CD_MDL_VD    
  WHERE   
	RC_CLI.CD_EMP  =@CD_EMP
	AND RC_CLI_CREDIARIO.CD_CLI = (CASE WHEN @CD_CLI = 0 THEN RC_CLI_CREDIARIO.CD_CLI ELSE @CD_CLI END);
	
  print 'update 1 #RS_CLI_CREDIARIO  ' + convert(varchar, getdate(),108);
  -----------------------------------------------------------------------------------------------------------------------------------------  
  -- Montando a data de vencimento da fatura com base na data de fechamento  
     -----------------------------------------------------------------------------------------------------------------------------------------  
  UPDATE #RS_CLI_CREDIARIO 
	SET   
	DT_VENCTO = DBO.F_RET_DATA_VALIDA  ((CASE WHEN TP_VENCTO = 0 THEN --Dia do Mes  
               CASE WHEN DAY(DT_FECHA) > DIA_VENCTO THEN  
               CAST(YEAR(DATEADD(MONTH, 1, DT_FECHA)) AS VARCHAR) + RIGHT('0' + CAST(MONTH(DATEADD(MONTH, 1, DT_FECHA)) AS VARCHAR),2) + RIGHT('0' +CAST(DIA_VENCTO AS VARCHAR),2)    
               ELSE  
               CAST(YEAR(DT_FECHA) AS VARCHAR) + RIGHT('0' + CAST(MONTH(DT_FECHA) AS VARCHAR),2) + RIGHT('0' +CAST(DIA_VENCTO AS VARCHAR),2)     
               END  
  
             WHEN TP_VENCTO = 1 THEN --Dias apos fechamento  
              (CASE WHEN NOT DT_FECHA IS NULL THEN  
               CONVERT(CHAR(10), DATEADD(DAY, DIA_VENCTO, DT_FECHA), 112)  
               ELSE  
               NULL  
               END)  
  
             WHEN TP_VENCTO = 2 THEN --Dia da semana  
              (CASE WHEN DATEPART(DW, DT_FECHA) >= DIA_VENCTO THEN  
               CONVERT(CHAR(10), DATEADD(DAY, (7 - DATEPART(DW, DT_FECHA)) + DIA_VENCTO, DT_FECHA), 112)           
               ELSE  
               CONVERT(CHAR(10), DATEADD(DAY, DIA_VENCTO - DATEPART(DW, DT_FECHA) , DT_FECHA), 112)  
               END)  
  
             WHEN TP_VENCTO = 3 THEN --Quinzenal  
              (CASE WHEN DAY(DT_FECHA) <= 15 THEN  
               CONVERT(CHAR(10), DBO.F_FINAL_MES(DT_FECHA), 112)  
               ELSE  
               CONVERT(CHAR(10), DATEADD(DAY, 15, DBO.F_FINAL_MES(DT_FECHA)), 112)           
               END)  
             END))    

	
  -----------------------------------------------------------------------------------------------------------------------------------------  
 END  
ELSE   
BEGIN  
print 'insert 2 #RS_CLI_CREDIARIO  ' + convert(varchar, getdate(),108);
	INSERT INTO #RS_CLI_CREDIARIO  
	SELECT  
		RC_CLI_CREDIARIO.CD_EMP,  
		RC_CLI_CREDIARIO.CD_CLI,  
		RC_CLI.RZ_CLI,  
		CONVERT(CHAR(10), @DT_FECHA, 112) AS DT_FECHA,  
		CONVERT(CHAR(10), @DT_FECHA, 112) AS DT_LIMITE_PGTO,  
		CONVERT(CHAR(10), @DT_VENCTO, 112) AS DT_VENCTO,  
		(SELECT MAX(CD_CTR_FECHA) FROM RC_CREDIARIO_FECHA WHERE CD_EMP = RC_CLI_CREDIARIO.CD_EMP AND CD_CLI = RC_CLI_CREDIARIO.CD_CLI AND FLAG_NAO_FECHAR = 0) AS CD_CTR_FECHA,  
		RC_MDL_VENDA.PERC_MIN_RECB_FAT,  
		RC_MDL_VENDA.PERC_JUROS_MULTA,  
		RC_MDL_VENDA.PERC_JUROS_ATRASO,  
		RC_MDL_VENDA.PERC_JUROS_REFIN,  
		RC_MDL_VENDA.DIAS_CAREN_ATRASO,  
		RC_CLI_CREDIARIO.CD_MDL_VD,  
		RC_MDL_VENDA.TP_VENCTO,  
		RC_MDL_VENDA.DIA_VENCTO,  
		RC_MDL_VENDA.DIA_FECHA,  
		ISNULL(RC_MDL_VENDA.FLAG_REFIN_SLD,0)  
	FROM   
		RC_CLI_CREDIARIO 
		INNER JOIN RC_MDL_VENDA ON  
		RC_CLI_CREDIARIO.CD_EMP		= RC_MDL_VENDA.CD_EMP   AND 
		RC_CLI_CREDIARIO.CD_MDL_VD  = RC_MDL_VENDA.CD_MDL_VD   
	
		INNER JOIN RC_CLI ON  
		RC_CLI_CREDIARIO.CD_EMP	= RC_CLI.CD_EMP   AND 
		RC_CLI_CREDIARIO.CD_CLI = RC_CLI.CD_CLI    

		INNER JOIN #RsMdlVd M ON 
		RC_MDL_VENDA.CD_EMP		= M.CD_EMP  AND 
		RC_MDL_VENDA.CD_MDL_VD  = M.CD_MDL_VD    

	WHERE 
		RC_CLI.CD_EMP  =@CD_EMP
		AND RC_CLI_CREDIARIO.CD_CLI = (CASE WHEN @CD_CLI = 0 THEN RC_CLI_CREDIARIO.CD_CLI ELSE @CD_CLI END);
 END  
  
-----------------------------------------------------------------------------------------------------------  
--Capturando parcelas em aberto e montando a data de fechamento e vencimento das parcelas  
----------------------------------------------------------------------------------------------------------- 

	print 'INSERT 3 #RS_MOV_CRED  ' + convert(varchar, getdate(),108); 
	INSERT INTO #RS_MOV_CRED   
	SELECT    
		RC_CREDIARIO_PARC.CD_CTR,  
		CLI_CREDIARIO.CD_CLI,   
		CLI_CREDIARIO.RZ_CLI,   
		RC_CREDIARIO_PARC.DT_LANC_CRED,  
		RC_CREDIARIO_PARC.DT_FECHA_CRED,  
  
		(CASE WHEN CLI_CREDIARIO.DT_FECHA IS NULL THEN   
		CONVERT(CHAR(10), DATEADD(DAY, DIA_FECHA, RC_CREDIARIO_PARC.DT_LANC_CRED), 112)  
		ELSE  
		CLI_CREDIARIO.DT_FECHA  
		END) AS DT_FECHA,  
  
		(CASE WHEN CLI_CREDIARIO.DT_LIMITE_PGTO IS NULL THEN   
		CONVERT(CHAR(10), DATEADD(DAY, DIA_FECHA + 30, RC_CREDIARIO_PARC.DT_LANC_CRED), 112)  
		ELSE  
		CLI_CREDIARIO.DT_LIMITE_PGTO  
		END) AS DT_LIMITE_PGTO,  
  
		(CASE WHEN CLI_CREDIARIO.DT_VENCTO IS NULL THEN   
		CONVERT(CHAR(10), DATEADD(DAY, DIA_VENCTO,  (CASE WHEN CLI_CREDIARIO.DT_FECHA IS NULL THEN 
													CONVERT(CHAR(10), DATEADD(DAY, DIA_FECHA, RC_CREDIARIO_PARC.DT_LANC_CRED), 112)  
													ELSE  
														CLI_CREDIARIO.DT_FECHA  
													END)), 112)  
		ELSE  
		CLI_CREDIARIO.DT_VENCTO  
		END) AS DT_VENCTO,  
  
		RC_CREDIARIO_PARC.SLD_PARC_CRED AS VLR_LANC,  
		NULL AS CD_CTR_FECHA,  
		CLI_CREDIARIO.PERC_MIN_RECB_FAT,  
		RC_CREDIARIO_PARC.CD_TP_LANC  
	FROM    
		RC_CREDIARIO_PARC INNER JOIN #RS_CLI_CREDIARIO CLI_CREDIARIO ON      
		RC_CREDIARIO_PARC.CD_EMP = CLI_CREDIARIO.CD_EMP AND      
		RC_CREDIARIO_PARC.CD_CLI = CLI_CREDIARIO.CD_CLI  


		LEFT OUTER JOIN RC_CREDIARIO_PARC_PDV_VD T2 ON     
		RC_CREDIARIO_PARC.CD_EMP = T2.CD_EMP 
		AND  RC_CREDIARIO_PARC.CD_CTR = T2.CD_CTR    
	
		LEFT OUTER JOIN PDV_VD_DEV_NCC_LANC_RC_CREDIARIO_PARC_CRED T7 ON     
		RC_CREDIARIO_PARC.CD_CTR = T7.CD_CTR 
	
		LEFT JOIN PDV_VD T1 ON     
		RC_CREDIARIO_PARC.CD_EMP = T2.CD_EMP 
		AND T1.CD_FILIAL = T2.CD_FILIAL 
		AND T1.CD_VD = T2.CD_VD  
		
		LEFT JOIN PRC_GRP_ECON_PRC_FILIAL ON
		PRC_GRP_ECON_PRC_FILIAL.CD_EMP=T2.CD_EMP AND
		PRC_GRP_ECON_PRC_FILIAL.CD_FILIAL=T2.CD_FILIAL

	WHERE   
		RC_CREDIARIO_PARC.CD_EMP = @CD_EMP   
		AND RC_CREDIARIO_PARC.STS_LANC_CRED in (0,2) AND T1.ST_VD <> 1  
		AND PRC_GRP_ECON_PRC_FILIAL.CD_GRP_ECON = (CASE WHEN @CD_GRP_ECON = 0 THEN  PRC_GRP_ECON_PRC_FILIAL.CD_GRP_ECON ELSE @CD_GRP_ECON END)
		AND CONVERT(CHAR(10), (CASE WHEN @TP_FECH = 1 THEN 
								RC_CREDIARIO_PARC.DT_LANC_CRED 
							ELSE 
								RC_CREDIARIO_PARC.DT_FECHA_CRED END), 112) 	<= 			  
							(CASE WHEN CLI_CREDIARIO.DT_FECHA IS NULL THEN  
									CONVERT(CHAR(10), DATEADD(DAY, DIA_FECHA, RC_CREDIARIO_PARC.DT_LANC_CRED), 112)  						
							ELSE  
									CLI_CREDIARIO.DT_FECHA  
							END) ;

  
print 'INSERT 4 #RS_MOV_CRED  ' + convert(varchar, getdate(),108); 
  
-----------------------------------------------------------------------------------------------------------  
--Capturando o saldo anterior  
-----------------------------------------------------------------------------------------------------------  
	INSERT INTO #RS_MOV_CRED   
	SELECT   
		fecha.CD_CTR_FECHA,   
		CLI_CREDIARIO.CD_CLI,   
		CLI_CREDIARIO.RZ_CLI,   
		fecha.DT_FECHA,  
		fecha.DT_FECHA,  
		fecha.DT_FECHA,  
		CLI_CREDIARIO.DT_LIMITE_PGTO,  
		CLI_CREDIARIO.DT_VENCTO,  
		CAST(saldo.VLR_SLD AS NUMERIC(18,2)) AS VLR_SLD_ANT,  
		fecha.CD_CTR_FECHA,  
		CLI_CREDIARIO.PERC_MIN_RECB_FAT,  
		6 AS CD_TP_LANC  
	FROM RC_CREDIARIO_FECHA_SALDO saldo   
		INNER JOIN RC_CREDIARIO_FECHA fecha ON  
		saldo.CD_CTR_FECHA = fecha.CD_CTR_FECHA  
		INNER JOIN #RS_CLI_CREDIARIO CLI_CREDIARIO ON  
		fecha.CD_EMP = CLI_CREDIARIO.CD_EMP AND  
		fecha.CD_CLI = CLI_CREDIARIO.CD_CLI AND  
		fecha.CD_CTR_FECHA = CLI_CREDIARIO.CD_CTR_FECHA  
	WHERE fecha.CD_EMP = @CD_EMP  
		AND fecha.STS_FECH_CRED = 0  
		AND saldo.VLR_SLD > 0  
		AND CLI_CREDIARIO.FLAG_REFIN_SLD = 1  
		AND fecha.FLAG_NAO_FECHAR = 0 ;
    
print 'INSERT #RS_MOV_CRED  ' + convert(varchar, getdate(),108); 
-----------------------------------------------------------------------------------------------------------  
--Capturando os encargos sobre refinanciamento de saldo devedor  
-----------------------------------------------------------------------------------------------------------  
	INSERT INTO #RS_MOV_CRED   
	SELECT   
		fecha.CD_CTR_FECHA,   
		CLI_CREDIARIO.CD_CLI,   
		CLI_CREDIARIO.RZ_CLI,   
		fecha.DT_FECHA,  
		fecha.DT_FECHA,  
		fecha.DT_FECHA,  
		CLI_CREDIARIO.DT_LIMITE_PGTO,  
		CLI_CREDIARIO.DT_VENCTO,  
		CAST((saldo.VLR_SLD * (ISNULL(CLI_CREDIARIO.PERC_JUROS_REFIN,0)) / 100) AS NUMERIC(18,2)) AS VLR_REFINANCIAMENTO,  
		fecha.CD_CTR_FECHA,  
		CLI_CREDIARIO.PERC_MIN_RECB_FAT,  
		4 AS CD_TP_LANC  
	FROM RC_CREDIARIO_FECHA_SALDO saldo   
		INNER JOIN RC_CREDIARIO_FECHA fecha ON  
		saldo.CD_CTR_FECHA = fecha.CD_CTR_FECHA  
		INNER JOIN #RS_CLI_CREDIARIO CLI_CREDIARIO ON  
		fecha.CD_EMP = CLI_CREDIARIO.CD_EMP AND  
		fecha.CD_CLI = CLI_CREDIARIO.CD_CLI AND  
		fecha.CD_CTR_FECHA = CLI_CREDIARIO.CD_CTR_FECHA  
	WHERE fecha.CD_EMP = @CD_EMP  
		AND fecha.STS_FECH_CRED = 0  
		AND saldo.VLR_SLD > 0  
		AND CLI_CREDIARIO.PERC_JUROS_REFIN > 0  
		AND CLI_CREDIARIO.FLAG_REFIN_SLD = 1  
		AND fecha.FLAG_NAO_FECHAR = 0  

print 'INSERT 5 #RS_MOV_CRED  ' + convert(varchar, getdate(),108); 
-----------------------------------------------------------------------------------------------------------  
--Capturando multa por atraso   
-----------------------------------------------------------------------------------------------------------  
	INSERT INTO #RS_MOV_CRED   
	SELECT   
		fecha_deb.CD_CTR_FECHA,   
		CLI_CREDIARIO.CD_CLI,   
		CLI_CREDIARIO.RZ_CLI,   
		RC_CRED.DT_PAG,  
		RC_CRED.DT_PAG,  
		CLI_CREDIARIO.DT_FECHA,  
		CLI_CREDIARIO.DT_LIMITE_PGTO,  
		CLI_CREDIARIO.DT_VENCTO,  
		CAST(((RC_DEB.VLR_DP * ISNULL(CLI_CREDIARIO.PERC_JUROS_MULTA,0)) / 100) AS NUMERIC(18,2)) AS VLR_MULTA,  
		NULL AS CD_CTR_FECHA,  
		CLI_CREDIARIO.PERC_MIN_RECB_FAT,  
		2 AS CD_TP_LANC  
	FROM   
		RC_CREDIARIO_FECHA_RC_DEB fecha_deb  
		INNER JOIN RC_CREDIARIO_FECHA fecha ON  
		fecha_deb.CD_EMP = fecha.CD_EMP  
		AND fecha_deb.CD_CTR_FECHA = fecha.CD_CTR_FECHA   INNER JOIN RC_DEB ON  
		fecha_deb.CD_EMP  = RC_DEB.CD_EMP    
		AND fecha_deb.CD_FILIAL = RC_DEB.CD_FILIAL  
		AND fecha_deb.CD_RC_DEB = RC_DEB.CD_RC_DEB  
		INNER JOIN RC_CRED ON  
		fecha_deb.CD_EMP = RC_CRED.CD_EMP  
		AND fecha_deb.CD_FILIAL = RC_CRED.CD_FILIAL  
		AND fecha_deb.CD_RC_DEB = RC_CRED.CD_RC_DEB   
		INNER JOIN #RS_CLI_CREDIARIO CLI_CREDIARIO ON  
		RC_DEB.CD_EMP    = CLI_CREDIARIO.CD_EMP   
		AND RC_DEB.CD_CLI   = CLI_CREDIARIO.CD_CLI   
		AND fecha_deb.CD_CTR_FECHA = CLI_CREDIARIO.CD_CTR_FECHA  
	WHERE  
		RC_CRED.DT_PAG > RC_DEB.DT_VENCTO  
		AND (DATEDIFF (day, RC_DEB.DT_VENCTO, RC_CRED.DT_PAG) - CLI_CREDIARIO.DIAS_CAREN_ATRASO) > 0  
		AND CLI_CREDIARIO.PERC_JUROS_MULTA > 0  
		AND CLI_CREDIARIO.FLAG_REFIN_SLD = 1  
		AND fecha.FLAG_NAO_FECHAR = 0;
  
print 'INSERT 6 #RS_MOV_CRED  ' + convert(varchar, getdate(),108); 
-----------------------------------------------------------------------------------------------------------  
--Capturando os encargos sobre atraso   
-----------------------------------------------------------------------------------------------------------  


INSERT INTO #rs_mov_cred_aux
	SELECT   
		fecha_deb.CD_CTR_FECHA,   
		CLI_CREDIARIO.CD_CLI,   
		CLI_CREDIARIO.RZ_CLI,   
		RC_CRED.DT_PAG,  
		RC_CRED.DT_PAG,  
		CLI_CREDIARIO.DT_FECHA,  
		CLI_CREDIARIO.DT_LIMITE_PGTO,  
		CLI_CREDIARIO.DT_VENCTO,  
		0 AS VLR_JUROS_ATRASO,  
		NULL AS CD_CTR_FECHA,  
		CLI_CREDIARIO.PERC_MIN_RECB_FAT,  
		3 AS CD_TP_LANC  ,
		CLI_CREDIARIO.PERC_JUROS_ATRASO PERC_JUROS_ATRASO,
		RC_CRED.VL_PGTO   RC_CRED_VL_PGTO ,
		RC_DEB.DT_VENCTO  RC_DEB_DT_VENCTO
		
	FROM RC_CREDIARIO_FECHA_RC_DEB fecha_deb  
		INNER JOIN RC_CREDIARIO_FECHA fecha ON  
		fecha_deb.CD_EMP = fecha.CD_EMP  
		AND fecha_deb.CD_CTR_FECHA = fecha.CD_CTR_FECHA  
		INNER JOIN RC_CRED ON  
		fecha_deb.CD_EMP = RC_CRED.CD_EMP  
		AND fecha_deb.CD_FILIAL = RC_CRED.CD_FILIAL  
		AND fecha_deb.CD_RC_DEB = RC_CRED.CD_RC_DEB  
		INNER JOIN RC_DEB ON  
		fecha_deb.CD_EMP		  = RC_DEB.CD_EMP  
		AND fecha_deb.CD_FILIAL = RC_DEB.CD_FILIAL  
		AND fecha_deb.CD_RC_DEB = RC_DEB.CD_RC_DEB  
		INNER JOIN #RS_CLI_CREDIARIO CLI_CREDIARIO ON  
		RC_DEB.CD_EMP    = CLI_CREDIARIO.CD_EMP   
		AND RC_DEB.CD_CLI   = CLI_CREDIARIO.CD_CLI   
		AND fecha_deb.CD_CTR_FECHA = CLI_CREDIARIO.CD_CTR_FECHA  
	   
	WHERE  
		RC_CRED.DT_PAG > RC_DEB.DT_VENCTO  
		AND (DATEDIFF (day, RC_DEB.DT_VENCTO, RC_CRED.DT_PAG) - CLI_CREDIARIO.DIAS_CAREN_ATRASO) > 0  
		AND CLI_CREDIARIO.PERC_JUROS_ATRASO > 0  
		AND CLI_CREDIARIO.FLAG_REFIN_SLD = 1  
		AND fecha.FLAG_NAO_FECHAR = 0  

	   create nonclustered index #ix_RS_MOV_CRED 
			 on #rs_mov_cred_aux (cd_cli, RC_DEB_DT_VENCTO)
			  
	   update r
	   set
		  VLR_LANC = CAST((RC_CRED_VL_PGTO * ((ISNULL(PERC_JUROS_ATRASO,0) / 30) * DATEDIFF (day, RC_DEB_DT_VENCTO, DT_LANC_CRED))) / 100 AS NUMERIC(18,2)) - 
				PAG.VLR_JUR 
	   from 		  
		  #rs_mov_cred_aux r
		  INNER JOIN V_QUITACOES PAG with(nolock) ON 
		  PAG.CD_CLI		 = r.CD_CLI
		  and pag.DT_VENCTO_FAT	 = r.RC_DEB_DT_VENCTO;
		
	   insert into #rs_mov_cred
	   select
		  CD_CTR  
		  ,CD_CLI
		  ,RZ_CLI
		  ,DT_LANC_CRED    
		  ,DT_FECHA_CRED   
		  ,DT_FECHA        
		  ,DT_LIMITE_PGTO  
		  ,DT_VENCTO     
		  ,VLR_LANC      
		  ,CD_CTR_FECHA  
		  ,PERC_MIN_RECB_FAt
		  ,CD_TP_LANC
	   from 
		  #rs_mov_cred_aux;
		 
print 'UPDATE  2 #RS_MOV_CRED  ' + convert(varchar, getdate(),108); 
  
-----------------------------------------------------------------------------------------------------------  
--Tratando a data de fechamento e vencimento para que seja uma data valida.  
-----------------------------------------------------------------------------------------------------------  
UPDATE #RS_MOV_CRED SET   
  DT_FECHA =  (CASE WHEN ISDATE(DT_FECHA) = 0 THEN  
      CONVERT(DATETIME, LEFT(DT_FECHA, 6) + CAST(DAY(DATEADD(MONTH, 1, CONVERT(DATETIME, LEFT(DT_FECHA, 6) + CAST('01' AS VARCHAR), 101)) - 1) AS VARCHAR), 101)  
      ELSE  
      DT_FECHA  
      END),  
  
  DT_LIMITE_PGTO =  (CASE WHEN ISDATE(DT_LIMITE_PGTO) = 0 THEN  
         CONVERT(DATETIME, LEFT(DT_LIMITE_PGTO, 6) + CAST(DAY(DATEADD(MONTH, 1, CONVERT(DATETIME, LEFT(DT_LIMITE_PGTO, 6) + CAST('01' AS VARCHAR), 101)) - 1) AS VARCHAR), 101)  
         ELSE  
         DT_LIMITE_PGTO  
         END),  
  
  DT_VENCTO = (CASE WHEN ISDATE(DT_VENCTO) = 0 THEN  
      CONVERT(DATETIME, LEFT(DT_VENCTO, 6) + CAST(DAY(DATEADD(MONTH, 1, CONVERT(DATETIME, LEFT(DT_VENCTO, 6) + CAST('01' AS VARCHAR), 101)) - 1) AS VARCHAR), 101)  
      ELSE  
       DT_VENCTO  
      END)  
WHERE ISDATE(DT_FECHA) = 0   
   OR ISDATE(DT_VENCTO) = 0  
  
  print 'DELETE 1 RC_CREDIARIO_PARC  ' + convert(varchar, getdate(),108); 
-----------------------------------------------------------------------------------------------------------  
--Deletando as previsoes de multas e encargos  
-----------------------------------------------------------------------------------------------------------  
CREATE NONCLUSTERED INDEX  #IX_RS_CLI_CREDIARIO ON  #RS_CLI_CREDIARIO 
(CD_EMP, CD_CLI);

	DELETE from a
	FROM 
	   RC_CREDIARIO_PARC a
	   inner join #RS_CLI_CREDIARIO  c on 
			 a.CD_EMP = C.CD_EMP   
		  AND a.CD_CLI = C.CD_CLI
	WHERE 
	   A.STS_LANC_CRED = 9   
			
  
  print 'INSERT 6 RC_CREDIARIO_PARC  ' + convert(varchar, getdate(),108); 
-----------------------------------------------------------------------------------------------------------  
--Montando somente as vendas correspondente ao fechamento selecionado  
-----------------------------------------------------------------------------------------------------------  
	INSERT INTO RC_CREDIARIO_PARC (CD_EMP, CD_CLI, PARC_CRED, DT_LANC_CRED, DT_FECHA_CRED, VLR_PARC_CRED, STS_LANC_CRED, CD_USU, DT_CAD, DT_ULT_ALT, CD_TP_LANC, QT_PARC_VD_CRED)  
	SELECT 
		@CD_EMP,  
		CD_CLI,  
		1 AS PARC_CRED,  
		DT_LANC_CRED,  
		DT_FECHA_CRED,  
		VLR_LANC,  
		9 AS STS_LANC_CRED,  
		1 AS CD_USU,  
		CONVERT(CHAR(10), @DT_BASE, 101) AS DT_CAD,  
		NULL AS DT_ULT_ALT,  
		CD_TP_LANC,  
		1 AS QT_PARC_VD_CRED  
	FROM 
		#RS_MOV_CRED  
	WHERE 
		CD_TP_LANC NOT IN (0,1)  
  
--------------------------------------------

	CREATE TABLE #RSNCC_Cred (CD_CLI INT, VLR_NCC MONEY);
 print 'INSERT 7 #RSNCC_Cred  ' + convert(varchar, getdate(),108); 
	INSERT INTO #RSNCC_Cred
	SELECT
		PDV_VD_DEV_NCC.CD_CLI,  
		SUM(PDV_VD_DEV_NCC.VLR_NCC) AS VLR_NCC  
	FROM   
		PDV_VD_DEV_NCC  
	WHERE  
		PDV_VD_DEV_NCC.STS_NCC=0 
		AND PDV_VD_DEV_NCC.CD_EMP=@CD_EMP
		AND EXISTS (SELECT  
						CD_CTR_NCC 
					FROM 
						PDV_VD_DEV_NCC_PDV_VD_DEV_EST_PROD_IMP IMP   
						INNER JOIN PDV_VD ON  
						PDV_VD.CD_EMP=IMP.CD_EMP AND   
						PDV_VD.CD_FILIAL=IMP.CD_FILIAL AND   
						PDV_VD.CD_VD=IMP.CD_VD WHERE PDV_VD_DEV_NCC.CD_CTR_NCC=IMP.CD_CTR_NCC)
		
		AND NOT EXISTS (SELECT  
							CD_EMP  
						FROM  
							PDV_VD_DEV_NCC_PDV_VD  
						WHERE  
							PDV_VD_DEV_NCC.CD_EMP=PDV_VD_DEV_NCC_PDV_VD.CD_EMP AND  
							PDV_VD_DEV_NCC.CD_FILIAL=PDV_VD_DEV_NCC_PDV_VD.CD_FILIAL AND  
							PDV_VD_DEV_NCC.CD_CTR_NCC=PDV_VD_DEV_NCC_PDV_VD.CD_CTR_NCC)  
						GROUP BY  
						PDV_VD_DEV_NCC.CD_FILIAL,  
						PDV_VD_DEV_NCC.CD_CLI;
						
	
	
	----cupons cancelados
	CREATE TABLE #RSRC_Cancel (CD_CLI INT, VLR_CANCELADO MONEY);
	print 'INSERT 8 #RSRC_Cancel  ' + convert(varchar, getdate(),108); 
	INSERT INTO #RSRC_Cancel
	SELECT 	 
		RC_CREDIARIO_PARC.CD_CLI,
		SUM(RC_CREDIARIO_PARC.VLR_PARC_CRED) AS VLR_CANCELADO
	FROM 
		PDV_VD 
		INNER JOIN RC_CREDIARIO_PARC_PDV_VD ON 
		PDV_VD.CD_EMP	=RC_CREDIARIO_PARC_PDV_VD.CD_EMP AND
		PDV_VD.CD_FILIAL=RC_CREDIARIO_PARC_PDV_VD.CD_FILIAL AND
		PDV_VD.CD_VD	=RC_CREDIARIO_PARC_PDV_VD.CD_VD 
		INNER JOIN RC_CREDIARIO_PARC ON 
		RC_CREDIARIO_PARC_PDV_VD.CD_CTR=RC_CREDIARIO_PARC.CD_CTR 	 
	WHERE
		PDV_VD.CD_EMP=@CD_EMP
		AND PDV_VD.ST_VD=1 
		AND RC_CREDIARIO_PARC.STS_LANC_CRED=0
	GROUP BY
		RC_CREDIARIO_PARC.CD_CLI;
	---------valores que ja participaram de outro fechamento
	CREATE TABLE #RSFecha_Cred (CD_CLI INT, VLR_PARC_CRED MONEY)
	print 'INSERT 9 #RSFecha_Cred  ' + convert(varchar, getdate(),108); 
	insert into #RSFecha_Cred
	SELECT 
		RC_CREDIARIO_PARC.CD_CLI,
		SUM(RC_CREDIARIO_PARC.VLR_PARC_CRED) AS VLR_PARC_CRED
	FROM 
		RC_CREDIARIO_PARC 
		INNER JOIN RC_CREDIARIO_PARC_RC_CREDIARIO_FECHA ON 
		RC_CREDIARIO_PARC.CD_CTR = RC_CREDIARIO_PARC_RC_CREDIARIO_FECHA.CD_CTR 
		INNER JOIN #RS_MOV_CRED R ON 
		RC_CREDIARIO_PARC.CD_CTR = R.CD_CTR 
	WHERE 
		RC_CREDIARIO_PARC.CD_EMP=@CD_EMP 
	GROUP BY 
		RC_CREDIARIO_PARC.CD_CLI

  print 'select 1  ' + convert(varchar, getdate(),108); 
-----------------------------------------------------------------------------------------------------------  
--Montando somente as vendas correspondente ao fechamento selecionado para o retorno da procedure  
-----------------------------------------------------------------------------------------------------------   
SELECT 
	MOV.CD_CLI,   
	MOV.RZ_CLI,   
	MAX(MOV.DT_FECHA) AS DT_FECHA,   
	MAX(MOV.DT_LIMITE_PGTO) AS DT_LIMITE_PGTO,    
	MAX(MOV.DT_VENCTO) AS DT_VENCTO,    
	SUM(MOV.VLR_LANC) AS VLR_LANC,  
	ISNULL(VLR_NCC,0) AS VLR_NCC,  
	CAST((SUM(MOV.VLR_LANC) * MOV.PERC_MIN_RECB_FAT) / 100 AS NUMERIC(18,2)) AS VLR_MIN_REB,  
	MAX(MOV.CD_CTR_FECHA) AS CD_CTR_FECHA,  
	CLI.FLAG_REFIN_SLD,
	ISNULL(FECHAMENTOS.VLR_PARC_CRED,0) AS VLR_PARC_FECHAMENTO,
	ISNULL(CANCELAMENTOS.VLR_CANCELADO,0) AS VLR_CANCELADO      
FROM   
	#RS_MOV_CRED MOV 
	INNER JOIN #RS_CLI_CREDIARIO CLI ON  
	mov.CD_CLI = CLI.CD_CLI   
	LEFT OUTER JOIN   #RSNCC_Cred ncc  ON  
	mov.CD_CLI = ncc.CD_CLI  
	LEFT JOIN #RSFecha_Cred FECHAMENTOS ON
	MOV.CD_CLI=FECHAMENTOS.CD_CLI 	
	LEFT JOIN #RSRC_Cancel CANCELAMENTOS	ON 
	MOV.CD_CLI=CANCELAMENTOS.CD_CLI	   
----------------------------------------------------------------------------------------------------
WHERE    
	CONVERT (CHAR(10), (CASE WHEN @TP_FECH = 0 THEN   
							MOV.DT_FECHA_CRED  
						ELSE  
							MOV.DT_FECHA  
						END), 112) <= CONVERT(CHAR(10), MOV.DT_FECHA, 112)  
	AND CONVERT (CHAR(10), (CASE WHEN @TP_FECH = 0 THEN   
			MOV.DT_FECHA  
		ELSE  
			MOV.DT_LANC_CRED  
		END), 112) <= CONVERT(CHAR(10), @DT_FECHA, 112)  
GROUP BY 
	MOV.CD_CLI,   
	MOV.RZ_CLI,    
	MOV.PERC_MIN_RECB_FAT,  
	CLI.FLAG_REFIN_SLD,  
	VLR_NCC,
	VLR_PARC_CRED,
	VLR_CANCELADO   
ORDER BY 
	MOV.RZ_CLI;

 print 'fim  ' + convert(varchar, getdate(),108); 
/**********************************************************************************************************************************/
 
DROP TABLE #RS_MOV_CRED
DROP TABLE #RS_MOV_CRED_AUX
DROP TABLE #RS_CLI_CREDIARIO  
DROP TABLE #RSMDLVD
drop table #RSNCC_Cred
drop table #RSRC_Cancel
drop table #RSFecha_Cred
 
END 